jQuery(document).ready(function($){
	'use strict';
	$('#submit_rules').on('click',function(){
		$.ajax( {
			type: 'POST',
			url: ajaxurl,
			data: {
				action: 'post_rules',
				rules: $("#frm_submit_rules").serialize()
			},
			success: ( response ) => {
				if (response.status) {
					$(".message_div").addClass('success-msg').html('Rules saved successfully');
				}
			},
			dataType: 'json',
		} );
	})
	$('.action').trigger('change');
	$('.trigger').trigger('change');

	$('#frm_submit_rules select').select2({minimumResultsForSearch: -1});

})



var $ = jQuery;


function fetchTriggerOptions(ev, actIndex){
	'use strict';
	var exist = $('option:selected', ev).attr('data-trigger-option');
	$(ev)
    .parents("td")
    .children(".inner_trigger_options")
    .remove();
	if (exist == false) {
		
		var index = $('option:selected', ev).attr('data-trigger-option-index');
		// fetch and put the option
			
		$.ajax( {
			type: 'POST',
			url: ajaxurl,
			data: {
				action: 'get_trigger_options',
				trigger_index: index.trim(),
				actIndex: actIndex
			},
			success: ( response ) => {
		
				$(response).insertAfter($(ev));
				$('#frm_submit_rules select').select2({minimumResultsForSearch: -1});
			},
			dataType: 'html',
		} );
	} 
}

function addNewRule() {
	'use strict';
	$.ajax( {
		type: 'GET',
		url: ajaxurl,
		data: {
			action: 'add_new_rule',
			actIndex: ($('.rule-set').size()*1)+1
		},
		success: ( response ) => {
			$(response).insertAfter($('.rule-set:last'));
			$('#frm_submit_rules select').select2({minimumResultsForSearch: -1});
		},
		dataType: 'html',
	} );
}


function deleteRule(ev) {
	'use strict';
	$(ev).parents('.rule-set').remove();
}	

function fetchActionsOptions(ev, actIndex){
	'use strict';
	var exist = $('option:selected', ev).attr('data-action-option');
	   $(ev)
       .parents("td")
       .children(".inner_action_option")
       .remove();
	if (exist == false) {
		var index = $('option:selected', ev).attr('data-action-option-index');
		// fetch and put the option
		$.ajax( {
			type: 'POST',
			url: ajaxurl,
			data: {
				action: 'get_action_options',
				action_index: index.trim(),
				actIndex: actIndex
			},
			success: ( response ) => {
				$(response).insertAfter($(ev));
				$('#frm_submit_rules select').select2({minimumResultsForSearch: -1});
			},
			dataType: 'html',
		} );
	} 
}


